/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.gui.ContainerLevelEmitter;
import com.tom.storagemod.network.IDataReceiver;
import com.tom.storagemod.network.NetworkHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiLevelEmitter
extends ContainerScreen<ContainerLevelEmitter>
implements IDataReceiver {
    private static final ResourceLocation gui = new ResourceLocation("toms_storage", "textures/gui/level_emitter.png");
    private GuiButton lessThanBtn;
    private TextFieldWidget textF;
    private boolean lt;
    private int count;
    private List<AmountBtn> amountBtns = new ArrayList<AmountBtn>();

    public GuiLevelEmitter(ContainerLevelEmitter screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.amountBtns.forEach(rec$ -> ((AmountBtn)rec$).update());
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (this.lessThanBtn.func_230449_g_()) {
            this.func_243308_b(matrixStack, Arrays.stream(I18n.func_135052_a((String)("tooltip.toms_storage.lvlEm_lt_" + this.lessThanBtn.state), (Object[])new Object[0]).split("\\\\")).map(StringTextComponent::new).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(gui);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_231160_c_() {
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        this.amountBtns.clear();
        super.func_231160_c_();
        this.field_230712_o_.getClass();
        this.textF = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 70, this.field_147009_r + 41, 89, 9, (ITextComponent)new TranslationTextComponent("narrator.toms_storage.level_emitter_amount"));
        this.textF.func_146203_f(100);
        this.textF.func_146185_a(false);
        this.textF.func_146189_e(true);
        this.textF.func_146193_g(0xFFFFFF);
        this.textF.func_146180_a("1");
        this.textF.func_212954_a(t -> {
            try {
                int c = Integer.parseInt(t);
                if (c >= 1) {
                    this.count = c;
                    this.send();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.func_230480_a_((Widget)this.textF);
        this.lessThanBtn = new GuiButton(this.field_147003_i - 18, this.field_147009_r + 5, 0, b -> {
            this.lt = !this.lt;
            this.lessThanBtn.state = this.lt ? 1 : 0;
            this.send();
        });
        this.func_230480_a_((Widget)this.lessThanBtn);
        this.amountBtns.add(new AmountBtn(20, 0, 1, 1, 20));
        this.amountBtns.add(new AmountBtn(45, 0, 10, 16, 25));
        this.amountBtns.add(new AmountBtn(75, 0, 100, 32, 30));
        this.amountBtns.add(new AmountBtn(110, 0, 1000, 64, 35));
        this.amountBtns.add(new AmountBtn(20, 40, -1, -1, 20));
        this.amountBtns.add(new AmountBtn(45, 40, -10, -16, 25));
        this.amountBtns.add(new AmountBtn(75, 40, -100, -32, 30));
        this.amountBtns.add(new AmountBtn(110, 40, -1000, -64, 35));
    }

    @Override
    public void receive(CompoundNBT tag) {
        this.count = tag.func_74762_e("count");
        boolean lt = tag.func_74767_n("lessThan");
        this.lessThanBtn.state = lt ? 1 : 0;
        this.lt = lt;
        this.textF.func_146180_a(Integer.toString(this.count));
    }

    private void send() {
        CompoundNBT mainTag = new CompoundNBT();
        mainTag.func_74768_a("count", this.count);
        mainTag.func_74757_a("lessThan", this.lt);
        NetworkHandler.sendDataToServer(mainTag);
    }

    private class AmountBtn {
        private Button btn;
        private int v;
        private int sv;

        public AmountBtn(int x, int y, int v, int sv, int len) {
            this.btn = new Button(GuiLevelEmitter.this.field_147003_i + x, GuiLevelEmitter.this.field_147009_r + y + 16, len, 20, (ITextComponent)new StringTextComponent((v > 0 ? "+" : "") + v), this::evt);
            GuiLevelEmitter.this.func_230480_a_((Widget)this.btn);
            this.v = v;
            this.sv = sv;
        }

        private void evt(Button b) {
            GuiLevelEmitter.this.count = GuiLevelEmitter.this.count + (Screen.func_231173_s_() ? this.sv : this.v);
            if (GuiLevelEmitter.this.count < 1) {
                GuiLevelEmitter.this.count = 1;
            }
            GuiLevelEmitter.this.textF.func_146180_a(Integer.toString(GuiLevelEmitter.this.count));
            GuiLevelEmitter.this.send();
        }

        private void update() {
            if (Screen.func_231173_s_()) {
                this.btn.func_238482_a_((ITextComponent)new StringTextComponent((this.sv > 0 ? "+" : "") + this.sv));
            } else {
                this.btn.func_238482_a_((ITextComponent)new StringTextComponent((this.v > 0 ? "+" : "") + this.v));
            }
        }
    }

    public class GuiButton
    extends Button {
        protected int tile;
        protected int state;
        protected int texX;
        protected int texY;

        public GuiButton(int x, int y, int tile, Button.IPressable pressable) {
            super(x, y, 16, 16, null, pressable);
            this.texX = 176;
            this.texY = 0;
            this.tile = tile;
        }

        public void setX(int i) {
            this.field_230690_l_ = i;
        }

        public void func_230431_b_(MatrixStack st, int mouseX, int mouseY, float pt) {
            if (this.field_230694_p_) {
                GuiLevelEmitter.this.field_230706_i_.func_110434_K().func_110577_a(gui);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_238474_b_(st, this.field_230690_l_, this.field_230691_m_, this.texX + this.state * 16, this.texY + this.tile * 16, this.field_230688_j_, this.field_230689_k_);
            }
        }
    }
}

